/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.rules.lad.core;

import java.io.Serializable;
import java.util.ArrayList;
import weka.classifiers.rules.lad.binarization.Cutpoints;
import weka.classifiers.rules.lad.core.BinaryRule;
import weka.classifiers.rules.lad.core.Literal;
import weka.core.Instance;

public class NumericalRule
implements Serializable {
    private static final long serialVersionUID = 7849846023533714647L;
    private boolean mClass;
    private double mPurity;
    private double mWeight;
    private ArrayList<NumericalCondition> mConditions;

    public NumericalRule(BinaryRule regraBinaria, Cutpoints pontosDeCorte) {
        this.mClass = regraBinaria.getRuleClass();
        this.mWeight = 0.0;
        this.mConditions = new ArrayList();
        this.mPurity = regraBinaria.getPurity();
        for (Literal u : regraBinaria.getLiterais()) {
            int indice = u.getAtt();
            boolean relation = u.getSign();
            int att = pontosDeCorte.attAt(indice);
            double value = pontosDeCorte.valueAt(indice);
            this.mConditions.add(new NumericalCondition(att, value, relation));
        }
    }

    public double getPurity() {
        return this.mPurity;
    }

    public boolean isPositive() {
        return this.mClass;
    }

    public boolean isNegative() {
        return !this.mClass;
    }

    public double getWeight() {
        if (this.mWeight < 0.0) {
            return 0.0;
        }
        return this.mWeight;
    }

    public void setWeight(double weight) {
        this.mWeight = weight;
    }

    public void increaseWeight(double inc) {
        this.mWeight += inc;
    }

    public void decreaseWeight(double dec) {
        this.mWeight -= dec;
    }

    public boolean isCovering(Instance inst) {
        for (NumericalCondition nCond : this.mConditions) {
            int att = nCond.mAtt;
            if (att < 0 || att >= inst.numAttributes() - 1) {
                System.out.println("Quem j\u00e1 viu?");
                return false;
            }
            if (inst.isMissing(att)) {
                return false;
            }
            if (!(nCond.mRelation ? inst.value(att) <= nCond.mValue : inst.value(att) > nCond.mValue)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        NumericalRule nRule = (NumericalRule)o;
        if (this.mClass != nRule.mClass || this.mConditions.size() != nRule.mConditions.size()) {
            return false;
        }
        for (NumericalCondition nCond : nRule.mConditions) {
            if (this.mConditions.contains(nCond)) continue;
            return false;
        }
        return true;
    }

    public String toString(String[] attNames) {
        if (attNames == null) {
            return this.toString();
        }
        String s = "";
        for (NumericalCondition nCond : this.mConditions) {
            s = String.valueOf(s) + " " + nCond.toString(attNames[nCond.mAtt]);
        }
        return s;
    }

    public String toString() {
        String s = "";
        for (NumericalCondition nCond : this.mConditions) {
            s = String.valueOf(s) + " " + nCond;
        }
        return s;
    }

    private class NumericalCondition
    implements Serializable {
        private static final long serialVersionUID = -145069372562872753L;
        private final Integer mAtt;
        private final Double mValue;
        private final boolean mRelation;

        public NumericalCondition(int att, double value, boolean relation) {
            this.mAtt = att;
            this.mValue = value;
            this.mRelation = relation;
        }

        public String toString(String attName) {
            return "[" + attName + (this.mRelation ? " > " : " <= ") + this.mValue + "]";
        }

        public String toString() {
            return this.toString("att" + this.mAtt);
        }

        public boolean equals(Object o) {
            NumericalCondition nCond = (NumericalCondition)o;
            boolean test = this.mAtt == nCond.mAtt;
            test &= Math.abs(this.mValue - nCond.mValue) < 0.001;
            return test &= this.mRelation == nCond.mRelation;
        }
    }
}

